/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.generator.map.square;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import org.betterx.bclib.api.v2.generator.BiomePicker;
import org.betterx.bclib.api.v2.generator.map.square.SquareBiomeChunk;
import org.betterx.bclib.interfaces.BiomeChunk;
import org.betterx.bclib.interfaces.BiomeMap;
import org.betterx.bclib.interfaces.TriConsumer;
import org.betterx.bclib.noise.OpenSimplexNoise;
import org.betterx.bclib.util.MHelper;

public class SquareBiomeMap
implements BiomeMap {
    private final Map<ChunkPos, SquareBiomeChunk> maps = Maps.newHashMap();
    private final OpenSimplexNoise noiseX;
    private final OpenSimplexNoise noiseZ;
    private final WorldgenRandom random;
    private final BiomePicker picker;
    private final int sizeXZ;
    private final int depth;
    private final int size;
    private TriConsumer<Integer, Integer, Integer> processor;

    public SquareBiomeMap(long seed, int size, BiomePicker picker) {
        this.random = new WorldgenRandom((RandomSource)new LegacyRandomSource(seed));
        this.noiseX = new OpenSimplexNoise(this.random.m_188505_());
        this.noiseZ = new OpenSimplexNoise(this.random.m_188505_());
        this.sizeXZ = size;
        this.depth = (int)Math.ceil(Math.log(size) / Math.log(2.0)) - 2;
        this.size = 1 << this.depth;
        this.picker = picker;
    }

    @Override
    public void clearCache() {
        if (this.maps.size() > 32) {
            this.maps.clear();
        }
    }

    @Override
    public BiomePicker.ActualBiome getBiome(double x, double y, double z) {
        BiomePicker.ActualBiome biome = this.getRawBiome(x, z);
        if (biome.getEdge() != null || biome.getParentBiome() != null && biome.getParentBiome().getEdge() != null) {
            int size;
            BiomePicker.ActualBiome search = biome;
            if (biome.getParentBiome() != null) {
                search = biome.getParentBiome();
            }
            boolean edge = !search.isSame(this.getRawBiome(x + (double)(size = search.bclBiome.settings.getEdgeSize()), z));
            edge = edge || !search.isSame(this.getRawBiome(x - (double)size, z));
            edge = edge || !search.isSame(this.getRawBiome(x, z + (double)size));
            edge = edge || !search.isSame(this.getRawBiome(x, z - (double)size));
            edge = edge || !search.isSame(this.getRawBiome(x - 1.0, z - 1.0));
            edge = edge || !search.isSame(this.getRawBiome(x - 1.0, z + 1.0));
            edge = edge || !search.isSame(this.getRawBiome(x + 1.0, z - 1.0));
            boolean bl = edge = edge || !search.isSame(this.getRawBiome(x + 1.0, z + 1.0));
            if (edge) {
                biome = search.getEdge();
            }
        }
        return biome;
    }

    @Override
    public void setChunkProcessor(TriConsumer<Integer, Integer, Integer> processor) {
        this.processor = processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BiomeChunk getChunk(int cx, int cz, boolean update) {
        ChunkPos cpos = new ChunkPos(cx, cz);
        SquareBiomeChunk chunk = this.maps.get(cpos);
        if (chunk == null) {
            WorldgenRandom worldgenRandom = this.random;
            synchronized (worldgenRandom) {
                this.random.m_190058_(0L, cpos.f_45578_, cpos.f_45579_, 0);
                chunk = new SquareBiomeChunk(this.random, this.picker);
            }
            this.maps.put(cpos, chunk);
            if (update && this.processor != null) {
                this.processor.accept(cx, cz, chunk.getSide());
            }
        }
        return chunk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BiomePicker.ActualBiome getRawBiome(double bx, double bz) {
        ChunkPos cpos;
        SquareBiomeChunk chunk;
        double x = bx * (double)this.size / (double)this.sizeXZ;
        double z = bz * (double)this.size / (double)this.sizeXZ;
        double px = bx * 0.2;
        double pz = bz * 0.2;
        for (int i = 0; i < this.depth; ++i) {
            double nx = (x + this.noiseX.eval(px, pz)) / 2.0;
            double nz = (z + this.noiseZ.eval(px, pz)) / 2.0;
            x = nx;
            z = nz;
            px = px / 2.0 + (double)i;
            pz = pz / 2.0 + (double)i;
        }
        int ix = MHelper.floor(x);
        int iz = MHelper.floor(z);
        if ((ix & 0xF) == 15) {
            x += (double)(iz / 2 & 1);
        }
        if ((iz & 0xF) == 15) {
            z += (double)(ix / 2 & 1);
        }
        if ((chunk = this.maps.get(cpos = new ChunkPos(MHelper.floor(x / 16.0), MHelper.floor(z / 16.0)))) == null) {
            WorldgenRandom worldgenRandom = this.random;
            synchronized (worldgenRandom) {
                this.random.m_190058_(0L, cpos.f_45578_, cpos.f_45579_, 0);
                chunk = new SquareBiomeChunk(this.random, this.picker);
            }
            this.maps.put(cpos, chunk);
        }
        return chunk.getBiome(MHelper.floor(x), MHelper.floor(z));
    }
}

